



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Videre med JSP</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">4 <a name='afsn4'></a>Videre med
JSP</H1>
<DIV ID="Indholdsfortegnelse5">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.1
  Sessioner  71</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.1.1
  Eksempel: En &oslash;nskeseddel  71</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.1.2
  Sessioner er individuelle  72</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.1.3
  At kassere en session  72</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.1.4
  Avanceret: URL Rewriting  72</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.2
  Eksempel: Login med adgangskode  73</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.2.1
  Inkludering af kodefragmenter  75</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.3
  Omdirigering  77</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.3.1
  Klient-omdirigering (response.sendRedirect())  77</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.3.2
  Server-omdirigering (&lt;jsp:forward /&gt;)  78</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.4
  Appendiks: Almindelige JSP-koder  79</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.5
  Appendiks: Implicit definerede objekter  80</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.1
  request - anmodningen fra klienten  80</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.2
  response - svaret til klienten  81</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.3
  out - skrive tekst til klienten  81</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.4
  session - objekt der f&oslash;lger den enkelte bruger  82</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.5
  application - f&aelig;lles for hele webapplikationen  83</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.6
  config - den enkelte websides konfiguration  84</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.7
  page - selve JSP-siden  85</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.8
  exception - undtagelse opst&aring;et under k&oslash;rsel  85</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.5.9
  pageContext - alle objekterne samlet i &eacute;t  85</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.6
  Opgaver  86</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.7
  Test dig selv  86</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.8
  Resum&eacute;  86</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>4.9
  Avanceret: Fejlfinding i JSP  87</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.9.1
  Del og hersk  87</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.9.2
  Tjek om blokparenteser er balancerede  87</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.9.3
  Kigge p&aring; den oversatte servlet  87</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.9.4
  Kigge i log-filerne  87</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.9.5
  Forst&aring; staksporet  88</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">4.9.6
  Hvis klasse(bibliotek)er ikke kan findes  88</FONT></FONT></P>
</DIV>

<P CLASS="kapiteloversigt-western">En overfladisk forst&aring;else af
emnerne i dette kapitel foruds&aelig;ttes i det meste af bogen.
Kapitlet foruds&aelig;tter k<SPAN LANG="da-DK">apitel 3, Interaktive sider.</SPAN></P>
<H2 CLASS="western" STYLE="">4.1 <a name='afsn4.1'></a>Sessioner</SPAN></H2>
<P CLASS="western">Hver bruger f&aring;r <SPAN LANG="da-DK">tildelt</SPAN>
et session-objekt, n&aring;r de bes&oslash;ger en JSP-side. Sessionen
f&oslash;lger brugeren, lige meget hvilken side han/hun er inde p&aring;
og er derfor nyttig til at huske data, der skal f&oslash;lge
brugeren. 
</P>
<P CLASS="western">Med den kan man gemme og hente oplysninger i l&oslash;bet
af en brugers bes&oslash;g. Det kunne f.eks. v&aelig;re om brugeren
har logget ind, et bruger-ID eller nogle oplysninger om hvilke valg,
brugeren har foretaget. I en e-handels-applikation ville
sessionsobjektet ogs&aring; v&aelig;re det helt rigtige at bruge til
at huske varerne i brugerens indk&oslash;bskurv.</P>
<P CLASS="western">De vigtigste metoder i session-objektet er
beskrevet i <a href='kapitel4.jsp#afsn4.5.4'>afsnit 4.5.4</a>. 
</P>
<H3 CLASS="western">4.1.1 <a name='afsn4.1.1'></a>Eksempel: En &oslash;nskeseddel</H3>
<P CLASS="western">Det f&oslash;lgende eksempel lader brugeren
indtaste nogle &oslash;nsker. &Oslash;nskerne huskes i en liste (af
type <SPAN LANG="da-DK">ArrayList</SPAN>), der gemmes i
sessionsobjektet (under navnet '&oslash;nsker').</P>
<PRE CLASS="kode-western">&lt;%@ page <SPAN LANG="da-DK">language</SPAN>=&quot;java&quot; import=&quot;<SPAN LANG="da-DK">java.util.</SPAN>*&quot; %&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;&Oslash;nskeseddel&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Dette eksempel demonstrerer, hvordan session-objektet kan bringes til at 
huske brugerens indtastninger.

&lt;h3&gt;Skriv et &oslash;nske&lt;/h3&gt;
Skriv noget, du &oslash;nsker.
&lt;form&gt;
&lt;input type=&quot;text&quot; name=&quot;<SPAN LANG="da-DK">oenske</SPAN>&quot;&gt;
&lt;/form&gt;
&lt;%
<I>  // hent listen over &oslash;nsker</I>
  ArrayList <B>&oslash;nsker = (ArrayList) <SPAN LANG="da-DK">session.getAttribute</SPAN>(&quot;&oslash;nsker&quot;)</B>;

  if (&oslash;nsker == null) {                      <I>// hvis listen ikke findes:</I>
    &oslash;nsker = new ArrayList();                <I>// opret den</I>
    <B><SPAN LANG="da-DK">session.setAttribute</SPAN>(&quot;&oslash;nsker&quot;, &oslash;nsker);</B>  <I>// og registrer den under &quot;&oslash;nsker&quot;</I>
  }

<I>  // se om der kommer en parameter med endnu et &oslash;nske</I>
  String &oslash;nske = request.getParameter(&quot;oenske&quot;);
  if (&oslash;nske != null) {
    <SPAN LANG="da-DK">&oslash;nsker.add</SPAN>(&oslash;nske);                       <I>// tilf&oslash;j &oslash;nske til listen</I>
  }

  if (<SPAN LANG="da-DK">&oslash;nsker.size</SPAN>()&gt;0) {                     <I>// udskriv &oslash;nsker i listen</I>
    %&gt;
      &lt;h3&gt;&Oslash;nskeseddel&lt;/h3&gt;
      Indtil nu har du f&oslash;lgende &oslash;nsker:&lt;br&gt;
    &lt;%
    <I>// udskriv hele listen</I>
    for (int i=0; i&lt;&oslash;nsker.size(); i++) 
    { %&gt;
      &Oslash;nske <SPAN LANG="da-DK">nr.</SPAN> &lt;%= i %&gt;: &lt;%= <SPAN LANG="da-DK">&oslash;nsker.get</SPAN>(i) %&gt;&lt;br&gt;
    &lt;% }

  }
%&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog5_html_mf2ca7e1.png" NAME="Grafik13" ALIGN=MIDDLE BORDER=0></P>
<H3 CLASS="western">4.1.2 <a name='afsn4.1.2'></a>Sessioner er individuelle</H3>
<P CLASS="western">Forestil dig, at 20 personer samtidigt klikker
rundt p&aring; det samme websted - f.eks. en e-butik. Oplysningerne
om, hvad deres indk&oslash;bskurve indeholder, kan med fordel gemmes
i sessionsobjektet. 
</P>
<P CLASS="western">For at kunne identificere brugerne i forhold til
hinanden, s&aring;dan at to brugere ikke ved et uheld f&aring;r
byttet session (og dermed varer i indk&oslash;bskurven!) bruger
serveren et <SPAN LANG="da-DK">unikt</SPAN> ID, som gemmes i en HTTP
cookie (en lille tekstfil p&aring; brugerens PC, se <a href='kapitel3.jsp#afsn3.6.5'>afsnit 3.6.5</a>).
Brug af sessioner kr&aelig;ver derfor normalt, at brugeren har sl&aring;et
underst&oslash;ttelse af cookier til i sin netl&aelig;ser (ellers m&aring;
man ty til 'URL Rewriting' beskrevet i <a href='kapitel4.jsp#afsn4.1.4'>afsnit 4.1.4</a>).</P>
<H3 CLASS="western">4.1.3 <a name='afsn4.1.3'></a>At kassere en session</H3>
<P CLASS="western">Vil du smide sessionen helt v&aelig;k, kan det
g&oslash;res med kaldet</P>
<PRE CLASS="kode-western">  <SPAN LANG="da-DK">session.invalidate</SPAN>()</PRE><P CLASS="western">
Herefter er sessionen og alle dens data v&aelig;k.</P>
<P CLASS="western">Hvis den p&aring;g&aelig;ldende bruger bes&oslash;ger
en side igen, vil hun blive tildelt en ny, tom session.</P>
<H3 CLASS="western">4.1.4 <a name='afsn4.1.4'></a>Avanceret: URL Rewriting</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel4.jsp#afsn4.1.4">
  <input type='checkbox' name='vis' value='4.1.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.1.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">4.2 <a name='afsn4.2'></a>Eksempel: Login med adgangskode</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel4.jsp#afsn4.2">
  <input type='checkbox' name='vis' value='4.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H3 CLASS="western">4.2.1 <a name='afsn4.2.1'></a>Inkludering af kodefragmenter</H3>
<P CLASS="western">I det foreg&aring;ende eksempel skulle alle
beskyttede sider have et ovenst&aring;ende tjek for, om brugeren er
logget korrekt ind.</P>
<P CLASS="western">Det kunne derfor nok betale sig at have denne
stump kode i en separat fil:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">logintjek.jsp</P>
<PRE CLASS="kode-western">&lt;%
<I>  // Filnavn: <SPAN LANG="da-DK">logintjek.jsp</SPAN></I>

<I>  // Se om attributten &quot;logget ind&quot; er sat i sessionen</I>
  if (<B>session.getAttribute(&quot;logget ind&quot;) == null</B>) {
    <I>// brugeren er ikke logget ind, s&aring; send ham tilbage til login-siden</I>
    response.sendRedirect(&quot;login1.html&quot;);
  }
%&gt;</PRE>
<P CLASS="western" STYLE="">Herefter kan
siderne blot inkludere fragmentet logintjek.jsp for at f&aring;
tjekket om brugeren er logget ind:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>login4.jsp</I></FONT></P>
<PRE CLASS="kode-western"><B>&lt;%@ <SPAN LANG="da-DK">include</SPAN> file=&quot;logintjek.jsp&quot; %&gt;</B>
&lt;html&gt;
&lt;head&gt;&lt;title&gt;login4&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;h1&gt;En anden beskyttet side&lt;/h1&gt;
Denne tekst kan du kun se, hvis du er logget korrekt p&aring;.

&lt;/body&gt;
&lt;/html&gt;</PRE><H2 CLASS="western">
4.3 <a name='afsn4.3'></a>Omdirigering</SPAN></H2>
<P CLASS="western">Ovenst&aring;ende eksempel viser ogs&aring;,
hvordan man omdirigerer brugeren til en anden side:</P>
<PRE CLASS="kode-western">  response.sendRedirect(&quot;login1.html&quot;);</PRE><P CLASS="western">
Brugeren vil da f&aring; siden login1.html i stedet for den side han
egentlig spurgte om.</P>
<P CLASS="western">Omdirigering foruds&aelig;tter, at der endnu ikke
er <SPAN LANG="da-DK">sendt</SPAN> nogen data til brugeren. For
JSP-sider sendes data normalt f&oslash;rst, n&aring;r afviklingen af
siden er afsluttet (output er <SPAN LANG="da-DK">buffered</SPAN>), s&aring;
en beslutning om omdirigering b&oslash;r ske tidligt<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>
p&aring; siden.</P>
<P CLASS="western">Omdirigering kan faktisk g&oslash;res p&aring; to
m&aring;der for JSP-sider: med response.sendRedirect():</P>
<PRE CLASS="kode-western">&lt;% response.sendRedirect(&quot;login1.html&quot;) %&gt;</PRE><P CLASS="western">
 eller med JSP-koden &lt;jsp:forward /&gt;:</P>
<PRE CLASS="kode-western">&lt;jsp:forward page=&quot;login1.html&quot;/&gt;</PRE><P CLASS="western">
Forskellen mellem de to m&aring;der er m&aring;den, som
<SPAN LANG="da-DK">omdirigeringen</SPAN> til den nye side foreg&aring;r
p&aring;: I det f&oslash;rste tilf&aelig;lde er klienten involveret i
omdirigeringen, i det andet tilf&aelig;lde sker omdirigeringen
internt p&aring; serveren, uden at klienten ved det.</P>
<P CLASS="western">Modsat hvad man m&aring;ske umiddelbart skulle
tro, bliver al javakoden <I>efter</I> (d.v.s. neden under) en
omdirigering faktisk udf&oslash;rt, selvom outputtet fra siden skal
kasseres<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.
</P>
<H3 CLASS="western">4.3.1 <a name='afsn4.3.1'></a>Klient-omdirigering
(response.sendRedirect())</H3>
<P CLASS="western">Med response.sendRedirect() sendes et speciel svar
til <SPAN LANG="da-DK">netl&aelig;seren</SPAN> om, at den side, den
lige har spurgt p&aring;, midlertidigt er flyttet et andet sted hen,
hvorefter netl&aelig;seren vil sp&oslash;rge en gang til p&aring; den
nye adresse.</P>
<P CLASS="western">Teknisk set sker der det, at serveren udnytter
HTTP-protokollen (beskrevet i <a href='kapitel3.jsp#afsn3.7'>afsnit 3.7</a>) til at omdirigere klienten.
N&aring;r klienten sp&oslash;rger p&aring; login3.jsp med:</P>
<PRE CLASS="ikke-javakode-western">GET /JSP/kode/kapitel_04/login3.jsp HTTP/1.1
Host: <SPAN LANG="da-DK">javabog.dk</SPAN>:8080
</PRE><P CLASS="western">
vil serveren, i stedet for at kvittere med et '200 OK' og sende data
som normalt, svare med et '302 Moved Temporarily' og fort&aelig;lle
klienten at den 'nye adresse' er login1.html: 
</P>
<PRE CLASS="ikke-javakode-western">HTTP/1.1 302 Moved Temporarily
<SPAN LANG="da-DK">Location</SPAN>: <B>http://<SPAN LANG="da-DK">javabog.dk</SPAN>:8080/JSP/kode/kapitel_04/login1.html</B>
</PRE><P CLASS="western">
<SPAN LANG="da-DK">Netl&aelig;seren</SPAN> reagerer p&aring; '302
Moved Temporarily' ved omg&aring;ende at sende en ny anmodning, der
sp&oslash;rger p&aring; den nye adresse:</P>
<PRE CLASS="kode-western">GET /JSP/kode/kapitel_04/login1.html HTTP/1.1
Host: <SPAN LANG="da-DK">javabog.dk</SPAN>:8080
</PRE><P CLASS="western">
Herefter forl&oslash;ber HTTP-kommunikationen som den plejer.</P>
<P CLASS="western"><SPAN LANG="da-DK">Netl&aelig;seren</SPAN> har
v&aelig;ret involveret i omdirigeringen og viser den nye URL i
adresselinjen. Parametrene til den oprindelige anmodning sendes <I>ikke</I>
igen sammen med den nye anmodning, de mistes.</P>
<H4 CLASS="western">Omdirigering med JavaScript</H4>
<P CLASS="western">JavaScript kan ogs&aring; bruges til at
omdirigering. F&oslash;lgende omdirigerer ogs&aring; til login1.html:</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Omdirigering med JavaScript&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
<B>&lt;script&gt;document.location=&quot;/JSP/kode/kapitel_04/login1.html&quot;&lt;/script&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
JavaScript udf&oslash;res i brugerens netl&aelig;seren og kan ikke
bruges til sikkerhedsforanstaltninger, j.v.f. <a href='kapitel8.jsp#afsn8.5'>afsnit 8.5</a>, Sikkerhed i en webapplikation
(det kan f.eks. deaktiveres af brugeren).</P>
<H3 CLASS="western">4.3.2 <a name='afsn4.3.2'></a>Server-omdirigering (&lt;jsp:forward /&gt;)</H3>
<P CLASS="western">Med &lt;jsp:forward /&gt; <SPAN LANG="da-DK">omdirigeres</SPAN>
anmodningen <I>internt</I> i serveren. Det vil sige at den
oprindelige anmodning klienten foretog (med de samme parametre etc.),
besvares af en anden side i serveren.</P>
<P CLASS="western">Svaret sendes derefter tilbage til klientens
netl&aelig;ser, der ikke ved, at der skete en omdirigering. Den viser
derfor den oprindelige URL i adresselinjen, ikke den nye adresse.</P>
<P CLASS="western"><SPAN LANG="da-DK">F.eks.</SPAN> kunne det v&aelig;re
at klienten skulle omdirigeres til login-siden:</P>
<PRE CLASS="kode-western">&lt;jsp:forward page=&quot;login2.jsp&quot;/&gt;</PRE><P CLASS="western">
Denne <SPAN LANG="da-DK">omdirigeringsmetode</SPAN> tillader at sende
parametre videre til <SPAN LANG="da-DK">modtagersiden</SPAN>, da det
samme request-objekt genbruges.</P>
<P CLASS="western">Man kan endda ogs&aring; <I>tilf&oslash;je</I>
parametre. Hvis brugeren eksempelvis kom ind p&aring; en side hvor
der i JSP-siden, serveren udf&oslash;rte, stod:</P>
<PRE CLASS="kode-western">&lt;jsp:forward page=&quot;login2.jsp&quot;&gt;
  &lt;jsp:param name=&quot;brugernavn&quot; value=&quot;Jacob&quot;/&gt;
  &lt;jsp:param name=&quot;adgangskode&quot; value=&quot;hemli&quot;/&gt;
&lt;/jsp:forward&gt;</PRE><P CLASS="western">
ville han blive automatisk logget ind (i &oslash;vrigt nok ikke
videre hensigtsm&aelig;ssigt).</P>
<H4 CLASS="western">Server-omdirigering fra <SPAN LANG="da-DK">javakode</SPAN></H4>
<P CLASS="western">Fra en <SPAN LANG="da-DK">servlet</SPAN>, eller
fra Java-koden i en JSP-side kunne man skrive:</P>
<PRE CLASS="kode-western"><SPAN LANG="da-DK">request.getRequestDispatcher</SPAN>(&quot;login2.jsp&quot;).forward(request,response);</PRE><H2 CLASS="western" STYLE="">
4.4 <a name='afsn4.4'></a>Appendiks: Almindelige JSP-koder</SPAN></H2>
<P CLASS="western">Her er en oversigt over almindelige JSP-koder, som
kan v&aelig;re nyttig til senere opslag.</P>
<TABLE BORDER=1 BORDERCOLOR="#000000" CELLPADDING=4 CELLSPACING=0>
  <COL>
  <COL>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">JSP-kode</P>
      </TH>
      <TH>
        <P CLASS="western">Betydning</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;% kode %&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western"><SPAN LANG="da-DK">Javakode</SPAN> der udf&oslash;res
        p&aring; serveren hver gang siden hentes.</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;%= udtryk %&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Et udtryk. V&aelig;rdien af <SPAN LANG="da-DK">udtrykket</SPAN>
        vil blive beregnet og indsat i stedet for koden. Eksempel (se
        ogs&aring; <a href='kapitel2.jsp#afsn2.2.1'>afsnit 2.2.1</a> Indlejrede java-udtryk):</P>
        <PRE CLASS="kode-western">Syv gange 2 er &lt;%= 7*2 %&gt;</PRE>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;%-- kommentar --%&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">En kommentar. Vil ikke blive <SPAN LANG="da-DK">udf&oslash;rt</SPAN>
        af serveren og vil aldrig blive sendt til klienten. Se ogs&aring;
        <a href='kapitel2.jsp#afsn2.5'>afsnit 2.5</a> Kommentarer.</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;%! erkl&aelig;ring %&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Variabel- og metodeerkl&aelig;ringer. Disse
        <SPAN LANG="da-DK">oprettes</SPAN>/defineres &eacute;n gang n&aring;r
        siden indl&aelig;ses (se <a href='kapitel2.jsp#afsn2.8.2'>afsnit 2.8.2</a>). Bruges sj&aelig;ldent.</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;%@ page ... %&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Side-direktivet, der indeholder information om
        siden, f.eks.:<BR>language=&quot;java&quot; (beskrivelse af
        sproget i siderne)<BR>import=&quot;java.util.*&quot; (import af
        klassedefinitioner)<BR>session=&quot;false&quot; (webserveren
        skal ikke holde styr p&aring;
        brugersessioner)<BR><SPAN LANG="da-DK">contentType</SPAN>=&quot;text/html<SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none"><SPAN LANG="da-DK">;charset=UTF-8</SPAN></SPAN></SPAN>&quot;
        (indholdstype og evt. tegns&aelig;t)<BR><SPAN LANG="da-DK">errorPage</SPAN>=&quot;<SPAN LANG="da-DK">fejl.jsp</SPAN>&quot;
        (opst&aring;r en undtagelse s&aring; vis fejl.jsp i
        stedet)<BR><SPAN LANG="da-DK">isErrorPage</SPAN>=&quot;true&quot;
        (hvis denne side er en fejlmeddelelsesside - f&aring;r defineret
        objektet <I>exception</I>, der beskriver fejlen. Se ogs&aring;
        <a href='kapitel10.jsp#afsn10.4.5'>afsnit 10.4.5</a>).</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;%@ taglib ... %&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Et JSP-kodebibliotek (eng.: Tag <SPAN LANG="da-DK">library</SPAN>).
         En <SPAN LANG="da-DK">kraftfuld</SPAN> m&aring;de at definere og
        anvende <SPAN LANG="da-DK">foruddefinerere</SPAN> JSP-funktioner
        p&aring; (se afsnit 6).</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;%@ include ... %&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Inklusions-direktivet. Inkluderer en fil (som
        om dens indhold blev klistret ind her - se <a href='kapitel4.jsp#afsn4.2.1'>afsnit 4.2.1</a> Inkludering af kodefragmenter).
        Eksempel</P>
        <PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;%@ include file=&quot;<SPAN LANG="da-DK">hej.jsp</SPAN>&quot; %&gt;</PRE>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;jsp:include ... /&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Kald en anden fil p&aring; <SPAN LANG="da-DK">k&oslash;retidspunktet</SPAN>
        (som om der blev lavet en foresp&oslash;rgsel p&aring; den) og
        inkluderer dens uddata her, f.eks.:</P>
        <PRE CLASS="kode-western">&lt;jsp:include page=&quot;hej.jsp&quot;/&gt;</PRE>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;jsp:forward ... /&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Omdirigerer til en anden side (som bliver
        kaldt i stedet, se <a href='kapitel4.jsp#afsn4.3.2'>afsnit 4.3.2</a>):</P>
        <PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;jsp:forward page=&quot;hej.jsp&quot;/&gt;</PRE>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;jsp:<SPAN LANG="da-DK">plugin</SPAN> ... /&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Genererer HTML-kode til en plugin. Bruges
        sj&aelig;ldent.<BR>F.eks. Java-plugin til appletter der skal k&oslash;re
        under JDK1.2:</P>
        <PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;jsp:plugin type=&quot;applet&quot; <SPAN LANG="da-DK">code</SPAN>=&quot;<SPAN LANG="da-DK">MinApplet.class</SPAN>&quot; <BR>            <SPAN LANG="da-DK">jreversion</SPAN>=&quot;1.2&quot; <SPAN LANG="da-DK">width</SPAN>=&quot;160&quot; <SPAN LANG="da-DK">height</SPAN>=&quot;150&quot; /&gt;</PRE>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P CLASS="western">&lt;jsp:...&gt;-koderne anvender XML-<SPAN LANG="da-DK">syntaks<SPAN STYLE="font-weight: medium">:
Koder der begynder med &lt;jsp: skal afsluttes med et /&gt; eller
ogs&aring; skal der v&aelig;re en tilsvarende slutkode</SPAN></SPAN>.
Det betyder at f.eks.:</P>
<PRE CLASS="kode-western">&lt;jsp:forward page=&quot;login1.html&quot;&gt;</PRE><P CLASS="western">
ikke m&aring; st&aring; alene, men <B>skal</B> afsluttes af den
tilsvarende slut-kode:</P>
<PRE CLASS="kode-western">&lt;/jsp:forward&gt;</PRE><P CLASS="western">
For at slippe for at skrive en masse slut-koder i de (mange!)
tilf&aelig;lde, hvor koden skal afsluttes lige efter at den er
startet, er der indf&oslash;rt en forkortet skrivem&aring;de:</P>
<PRE CLASS="kode-western">&lt;jsp:forward page=&quot;login1.html&quot;/&gt;</PRE><P CLASS="western">
 hvor man afslutter koden med /&gt; til sidst. Dette svarer alts&aring;
til</P>
<PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;jsp:forward page=&quot;login1.html&quot;&gt;&lt;/jsp:forward&gt;</PRE><H2 CLASS="western">
4.5 <a name='afsn4.5'></a>Appendiks: Implicit definerede objekter</SPAN></H2>
<P CLASS="western">Der findes en r&aelig;kke implicit definerede
objekter, som man altid har adgang til i en JSP-side. I det f&oslash;lgende
vil disse objekter og deres vigtigste metoder blive beskrevet.</P>
<H3 CLASS="western">4.5.1 <a name='afsn4.5.1'></a>request - anmodningen fra klienten</H3>
<P CLASS="western">Objektet request (af type <SPAN LANG="da-DK">HttpServletRequest</SPAN>
i pakken <SPAN LANG="da-DK">javax.servlet.http</SPAN>) repr&aelig;senterer
anmodningen fra klienten (i en servlet bliver request-objektet
overf&oslash;rt i <SPAN LANG="da-DK">doGet</SPAN>()-metoden).</P>
<P CLASS="western">Objektet kan bruges til at f&aring; information om
klienten (se eksempel i <a href='kapitel2.jsp#afsn2.4'>afsnit 2.4</a>), <SPAN LANG="da-DK">formulardata</SPAN>
fra klienten (se afsnit <SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none">3.2.5)
og informationer </SPAN></SPAN>om gemte cookier (se <SPAN LANG="da-DK">afsnit</SPAN>
3.6.5).</P>
<P CLASS="klasseoversigt-western">String <B><SPAN LANG="da-DK">getRequestURL</SPAN></B>()<BR>Giver
den fulde URL p&aring; siden, der anmodes om, med maskinnavn og med
evt parametre</P>
<P CLASS="klasseoversigt-western">String <B><SPAN LANG="da-DK">getMethod</SPAN></B>()<BR>Giver
anmodningsmetoden, som normalt er &quot;GET&quot;. For formularer kan
&quot;POST&quot; ogs&aring; forekomme (en tredje mulighed, &quot;PUT&quot;
bruges til at sende filer til serveren). Se <a href='kapitel3.jsp#afsn3.6.4'>afsnit 3.6.4</a>.</P>
<P CLASS="klasseoversigt-western">String <B><SPAN LANG="da-DK">getProtocol</SPAN></B>()<BR>Giver
versionen af HTTP-protokollen klienten har anvendt, typisk &quot;HTTP/1.1&quot;</P>
<P CLASS="klasseoversigt-western">String <SPAN LANG="da-DK"><B>getServerName()<BR></B><SPAN STYLE="font-weight: medium">Giver
v&aelig;rtsnavnet (eng.: host name), f.eks: &quot;javabog.dk&quot;.</SPAN></SPAN></P>
<P CLASS="klasseoversigt-western">String <B>getContextPath()<BR></B>Giver
stien til webapplikationens rod.</P>
<P CLASS="klasseoversigt-western">String <B>getServletPath()<BR></B>Giver
stien p&aring; serveren p&aring; siden, der anmodes om (evt.
parametre er fjernet), relativt til webapplikationens rod. Med
application.getRealPath(request.getServletPath()) kan man finde den
absolutte sti og filnavnet til, hvor en JSP-side ligger fysisk p&aring;
harddisken (vist i <a href='kapitel2.jsp#afsn2.8.1'>afsnit 2.8.1</a>).</P>
<P CLASS="klasseoversigt-western" STYLE="text-decoration: none"><SPAN STYLE="font-weight: medium">String
</SPAN><B><SPAN LANG="da-DK">getRemoteAddr</SPAN></B><SPAN STYLE="font-weight: medium">()
og </SPAN><B><SPAN LANG="da-DK">getRemoteHost</SPAN></B><SPAN STYLE="font-weight: medium">()
<BR>Giver adressen (som IP-nummer eller evt med navn) p&aring;
klienten, der foretager anmodningen</SPAN></P>
<P CLASS="klasseoversigt-western"><SPAN STYLE="text-decoration: none"><SPAN STYLE="font-weight: medium">String
</SPAN><B><SPAN LANG="da-DK">getLocale</SPAN></B><SPAN STYLE="font-weight: medium">()<BR>Giver
brugerens foretrukne sprog</SPAN></SPAN> (se eksempel p&aring; brug <SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none">i
<a href='kapitel2.jsp#afsn2.4'>afsnit 2.4</a> og </SPAN></SPAN><a href='kapitel13.jsp#afsn13.2'>afsnit 13.2</a>)<SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none"><BR></SPAN></SPAN><BR><BR>
</P>
<P CLASS="klasseoversigt-western" STYLE="text-decoration: none"><SPAN STYLE="font-weight: medium">String
</SPAN><B><SPAN LANG="da-DK">getParameter</SPAN></B><SPAN STYLE="font-weight: medium">(String
parameternavn)<BR>Giver v&aelig;rdien af en parameter fra klienten -
typisk fra en udfyldt formular, eller fra URLen. F.eks hvis en side
bliver kaldt som <SPAN LANG="da-DK">side.jsp</SPAN>?x=a siges det, at
den har parameteren x med v&aelig;rdien a og getParameter(&quot;x&quot;)
vil returnere strengen &quot;a&quot;.</SPAN></P>
<P CLASS="klasseoversigt-western" STYLE="font-weight: medium; text-decoration: none">
String[] <B><SPAN LANG="da-DK">getParameterValues</SPAN></B>(String
parameternavn)<BR>Giver et array af v&aelig;rdier for et
parameternavn. HTTP-protokollen tillader, at parametre har flere
v&aelig;rdier. F.eks. vil side.jsp?x=<SPAN LANG="da-DK">aaa</SPAN>&amp;x=<SPAN LANG="da-DK">bbb</SPAN>&amp;x=<SPAN LANG="da-DK">ccc</SPAN>,
hvor parameteren &quot;x&quot; har tre v&aelig;rdier, f&aring;
getParameterValues(&quot;x&quot;) til at returnere et array med
v&aelig;rdier {&quot;aaa&quot;, &quot;bbb&quot;, &quot;ccc&quot;}. Se
<a href='kapitel3.jsp#afsn3.2.5'>afsnit 3.2.5</a>. 
</P>
<P CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium"><SPAN LANG="da-DK">Enumeration</SPAN>
</SPAN><B><SPAN LANG="da-DK">getParameterNames</SPAN></B><SPAN STYLE="font-weight: medium">()</SPAN><BR>Giver
en opremsning (eng.: <SPAN LANG="da-DK">enumeration</SPAN>) hvor
hvert element er navnet p&aring; en parameter.<BR>F.eks vil
<SPAN STYLE="font-weight: medium">getParameterNames() give en
opremsning med &quot;x&quot;, &quot;y&quot; og &quot;y2&quot; for <SPAN STYLE="text-decoration: none">en
side kaldt med: side.jsp?x=aaa&amp;y=bbb?y2=ccc. Se et eksempel p&aring;
brug i <a href='kapitel3.jsp#afsn3.2.5'>afsnit 3.2.5</a></SPAN></SPAN>.</P>
<P CLASS="klasseoversigt-western"><SPAN STYLE="text-decoration: none"><SPAN STYLE="font-weight: medium">Cookie[]
</SPAN><B>getCookies</B><SPAN STYLE="font-weight: medium">()<BR>Giver
et array af cookier, der er sat hos klienten (netl&aelig;seren). Se
<a href='kapitel3.jsp#afsn3.6.5'>afsnit 3.6.5</a>, hvor der ogs&aring; er et eksempel.</SPAN></SPAN></P>

<H3 CLASS="western">4.5.2 <a name='afsn4.5.2'></a>response - svaret til klienten</H3>
<P CLASS="western">Objektet response (af type <SPAN LANG="da-DK">HttpServletResponse</SPAN>
i pakken javax.servlet.http) repr&aelig;senterer svaret p&aring;
anmodningen (i en servlet bliver response-objektet overf&oslash;rt i
doGet()-metoden). Objektet har information og data til klienten,
herunder hvilke cookier der evt. skal s&aelig;ttes i klienten.</P>
<P CLASS="western">De vigtigste metoder er:</P>
<P CLASS="klasseoversigt-western"><SPAN STYLE="text-decoration: none"><SPAN STYLE="font-weight: medium">void
</SPAN><B><SPAN LANG="da-DK">setContentType</SPAN></B><SPAN STYLE="font-weight: medium">(String
indholdstype)<BR>S&aelig;tter indholdstypen (MIME-typen).
Indholdstypen er fra systemets side sat til &quot;text/html&quot;.<BR>&Oslash;nsker
man at sende andre slags data, f.eks. bin&aelig;re, skal
indholdstypen s&aelig;ttes til &quot;image/jpeg&quot;
(jpeg-billeder), &quot;<SPAN LANG="da-DK">audio</SPAN>/x-<SPAN LANG="da-DK">wav</SPAN>&quot;
(wav-lyde) eller &quot;application/x-dit-eget-valg&quot; hvis det er
en helt <SPAN LANG="da-DK">selvopfunden</SPAN> indholdstype. Se et
eksempel i <a href='kapitel2.jsp#afsn2.8.4'>afsnit 2.8.4</a>, Producere grafik fra JSP.<BR>Tegns&aelig;ttet
kan ogs&aring; s&aelig;ttes, f.eks. til Unicode
(indholdstype<SPAN LANG="da-DK">=&quot;text/html;charset=UTF-8&quot;).</SPAN></SPAN></SPAN></P>
<P CLASS="klasseoversigt-western">void <B>addCookie</B>(Cookie
cookie)<BR>S&aelig;tter eller tilf&oslash;jer en <SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none">cookie
hos klienten (netl&aelig;seren).</SPAN></SPAN> Se <a href='kapitel3.jsp#afsn3.6.5'>afsnit 3.6.5</a>.</P>
<P CLASS="klasseoversigt-western">void <B><SPAN LANG="da-DK">sendRedirect</SPAN></B>(String
<SPAN LANG="da-DK">url</SPAN>)<BR>Omdirigerer klienten til en anden
side, den skal sp&oslash;rge p&aring; i stedet for denne side.
Adressen i url kan godt v&aelig;re relativ. Relateret til
&lt;jsp:forward ... /&gt;, se <a href='kapitel4.jsp#afsn4.3'>afsnit 4.3</a>, Omdirigering.</P>

<H3 CLASS="western">4.5.3 <a name='afsn4.5.3'></a>out - skrive tekst til klienten</H3>
<P CLASS="western">Objektet out (af type <SPAN LANG="da-DK">JspWriter</SPAN>
i pakken <SPAN LANG="da-DK">javax.servlet.jsp</SPAN>) repr&aelig;senterer
<SPAN LANG="da-DK">datastr&oslash;mmen,</SPAN> der bliver sendt til
klienten. 
</P>
<P CLASS="western">Det bruges lige som <SPAN LANG="da-DK">System.out</SPAN>:</P>
<PRE CLASS="kode-western">  out.println( &quot;&lt;h1&gt;Hej verden!&lt;/h1&gt;&quot; );</PRE>


<H3 CLASS="western">4.5.4 <a name='afsn4.5.4'></a>session - objekt der f&oslash;lger den
enkelte bruger</H3>
<P CLASS="western">Hver bruger f&aring;r<A CLASS="sdfootnoteanc" NAME="sdfootnote3anc" HREF="#sdfootnote3sym"><SUP>3</SUP></A>
tildelt et session-objekt (af type <SPAN LANG="da-DK">HttpSession</SPAN>
i pakken javax.servlet.http), der repr&aelig;senterer brugerens
session. Det f&oslash;lger brugeren, lige meget hvilken side han/hun
er inde p&aring;, og er derfor nyttigt til at huske data, der skal
f&oslash;lge brugeren, f.eks om vedkommende er logget ind,
sessions-ID og brugeroplysninger.</P>
<P CLASS="klasseoversigt-western">void <B><SPAN LANG="da-DK">setAttribute</SPAN></B>(String
n&oslash;gle, <SPAN LANG="da-DK">Object</SPAN> v&aelig;rdi)<BR>Gemmer
et objekt under navnet <I>n&oslash;gle</I>.</P>
<P CLASS="klasseoversigt-western">Object <B><SPAN LANG="da-DK">getAttribute</SPAN></B>(String
n&oslash;gle)<BR>Henter objektet under navnet <I>n&oslash;gle</I>.</P>
<P CLASS="klasseoversigt-western">void <B><SPAN LANG="da-DK">removeAttribute</SPAN></B>(String
n&oslash;gle)<BR>Sletter referencen til objektet under navnet <I>n&oslash;gle</I>.</P>
<P CLASS="klasseoversigt-western">String[] <B><SPAN LANG="da-DK">getAttributeNames</SPAN></B>()<BR>Giver
et array af alle n&oslash;gler der er defineret.</P>
<P CLASS="klasseoversigt-western"><SPAN LANG="da-DK">long</SPAN>
<B><SPAN LANG="da-DK">getLastAccessedTime</SPAN></B>()<BR>Giver antal
<SPAN LANG="da-DK">millisekunder</SPAN> siden sessionen sidst var i
brug</P>
<P CLASS="klasseoversigt-western">int <B><SPAN LANG="da-DK">getMaxInactiveInterval</SPAN></B>()<BR>Hvor
lang tid (i sekunder) der g&aring;r f&oslash;r sessionen bliver smidt
v&aelig;k, hvis den ikke bruges.</P>
<P CLASS="klasseoversigt-western">void <B><SPAN LANG="da-DK">setMaxInactiveInterval</SPAN></B>(int
sekunder)<BR>S&aelig;tter hvor lang tid (i sekunder) der g&aring;r
f&oslash;r en session, der ikke bruges, skal <SPAN LANG="da-DK">smides</SPAN>
v&aelig;k.</P>
<P CLASS="klasseoversigt-western">void <B><SPAN LANG="da-DK">invalidate</SPAN></B>()<BR>Smider
sessionen v&aelig;k. Hvis den p&aring;g&aelig;ldende bruger bes&oslash;ger
en side igen, vil hun blive tildelt en ny session.</P>



<H3 CLASS="western">4.5.5 <a name='afsn4.5.5'></a>application - f&aelig;lles for hele
webapplikationen</H3>
<P CLASS="western">Objektet application (af type <SPAN LANG="da-DK">ServletContext</SPAN>
i pakken <SPAN LANG="da-DK">javax.servlet</SPAN>) er f&aelig;lles for
alle sider og alle brugere af webapplikationen. Det kan bruges til at
huske 'globale' data<A CLASS="sdfootnoteanc" NAME="sdfootnote4anc" HREF="#sdfootnote4sym"><SUP>4</SUP></A>.
</P>
<P CLASS="western">Derudover kan den bruges til logning i
<SPAN LANG="da-DK">webserverens</SPAN> log og til at <SPAN LANG="da-DK">fremfinde</SPAN>
<SPAN LANG="da-DK">initialiseringsparametre</SPAN> fra <SPAN LANG="da-DK">web.xml</SPAN>,
den globale <SPAN LANG="da-DK">konfigurationsfil</SPAN> for
webapplikationen.</P>
<P CLASS="klasseoversigt-western">void <B>setAttribute</B>(String
n&oslash;gle, Object v&aelig;rdi)<BR>Gemmer et objekt under navnet
<I>n&oslash;gle</I>.</P>
<P CLASS="klasseoversigt-western">Object <B>getAttribute</B>(String
n&oslash;gle)<BR>Henter objektet under navnet <I>n&oslash;gle</I>.</P>
<P CLASS="klasseoversigt-western">void <B>removeAttribute</B>(String
n&oslash;gle)<BR>Sletter referencen til objektet under navnet <I>n&oslash;gle</I>.</P>
<P CLASS="klasseoversigt-western">Enumeration
<B>getAttributeNames</B>()<BR>Giver en opremsning af alle n&oslash;gler
der er defineret.</P>

<P CLASS="klasseoversigt-western">void <B>log</B>(String besked)</P>
<P CLASS="klasseoversigt-western">  Logger en besked.</P>
<P CLASS="klasseoversigt-western">void <B>log</B>(String besked,
<SPAN LANG="da-DK">Throwable</SPAN> undtagelse)</P>
<P CLASS="klasseoversigt-western">  Logger en fejlmeddelelse og en
supplerende undtagelse, hvis <SPAN LANG="da-DK">stakspor</SPAN>
skrives til loggen.</P>
<P CLASS="klasseoversigt-western">String <B><SPAN LANG="da-DK">getRealPath</SPAN></B>(String
url_i_<SPAN LANG="da-DK">webapp</SPAN>)</P>
<P CLASS="klasseoversigt-western">  Giver den rigtige sti (p&aring;
harddisken) ud fra en URL i webapplikationen. Er nyttigt til at
indl&aelig;se og behandle filer fra harddisken, der befinder sig i
samme <SPAN LANG="da-DK">webapplikation</SPAN>, se <a href='kapitel2.jsp#afsn2.8.6'>afsnit 2.8.6</a>.<BR>Med
application.getRealPath(request.getServletPath()) kan man finde den
absolutte sti og filnavnet til hvor en JSP-side ligger fysisk p&aring;
harddisken (dette er vist i <a href='kapitel2.jsp#afsn2.8.1'>afsnit 2.8.1</a>).</P>

<P CLASS="klasseoversigt-western">String <B><SPAN LANG="da-DK">getInitParameter</SPAN></B>(String
navn)</P>
<P CLASS="klasseoversigt-western">  Giver v&aelig;rdien af
<SPAN LANG="da-DK">initialiseringsparameteren</SPAN> <I>navn</I>
defineret i <SPAN LANG="da-DK">webapplikationens</SPAN> web.xml.</P>
<P CLASS="klasseoversigt-western">Enumeration <B><SPAN LANG="da-DK">getInitParameterNames</SPAN></B>()</P>
<P CLASS="klasseoversigt-western">  Giver en opremsning af navnene p&aring;
alle <SPAN LANG="da-DK">initialiseringsparametrene</SPAN> defineret i
web.xml.</P>
<H4 CLASS="western">Initialiseringsparametre</H4>
<P CLASS="western">application-objektet giver ogs&aring; adgang til
initialiseringsparametre fra web.xml.</P>
<P CLASS="western">Initialiseringsparametre er meget <SPAN LANG="da-DK">hensigtsm&aelig;ssige</SPAN>
til f.eks. at l&aelig;gge navne p&aring; <SPAN LANG="da-DK">databasedrivere</SPAN>
og database-URLer og lignende faste oplysninger. Det g&oslash;res ved
at lave en indgang af typen <SPAN LANG="da-DK">context</SPAN>-param,
f.eks. med databasedriveren, i web.xml:</P>
<PRE CLASS="kode-western">&lt;web-<SPAN LANG="da-DK">app</SPAN>&gt;
  ...
<B>  &lt;context-param&gt;</B>
<B>    &lt;param-name&gt;<SPAN LANG="da-DK">dbDriver</SPAN>&lt;/param-name&gt;</B>
<B>    &lt;param-value&gt;<SPAN LANG="da-DK">com.mysql.jdbc.Driver</SPAN>&lt;/param-value&gt;</B>
<B>  &lt;/context-param&gt;</B>
  ...
&lt;/web-app&gt;</PRE>
<P CLASS="western">Nu vil man i en JSP-side kunne hente v&aelig;rdien
af <SPAN LANG="da-DK">initialiseringsparameteren</SPAN> dbDriver med:</P>
<PRE CLASS="kode-western">    String <SPAN LANG="da-DK">drv</SPAN> = <SPAN LANG="da-DK">application.getInitParameter</SPAN>(&quot;dbDriver&quot;);</PRE><P CLASS="western">
hvorefter strengen drv vil have indholdet '<SPAN LANG="da-DK">com.mysql.jdbc.Driver'.</SPAN>
Der er et eksempel p&aring; dette i <a href='kapitel8.jsp#afsn8.5.8'>afsnit 8.5.8</a>.</P>

<P CLASS="western">Fra en servlet (se <a href='kapitel7.jsp#afsn7.1'>afsnit 7.1</a>, Servletter) er
application-objektet <SPAN LANG="da-DK">tilg&aelig;ngeligt</SPAN>
med:</P>
<PRE CLASS="kode-western">    ServletContext application = <SPAN LANG="da-DK">getServletContext</SPAN>();</PRE><P CLASS="western">
hvorefter v&aelig;rdien f&aring;s som i en JSP-side med:</P>
<PRE CLASS="kode-western">    String drv = application.getInitParameter(&quot;dbDriver&quot;);</PRE>
<P CLASS="western">I <a href='kapitel9.jsp#afsn9.5'>afsnit 9.5</a>, Eksempel: Login og brugeroprettelse,
kan man se hvordan en ekstern klasse (en <SPAN LANG="da-DK">javab&oslash;nne,
vist i <a href='kapitel9.jsp#afsn9.5.2'>afsnit 9.5.2</a></SPAN>) kan bruge application-objektet til af f&aring;
initialiseringsparametre.</P>

<H3 CLASS="western">4.5.6 <a name='afsn4.5.6'></a>config - den enkelte websides konfiguration</H3>
<P CLASS="western">Objektet config (af type <SPAN LANG="da-DK">ServletConfig</SPAN>
i pakken javax.servlet) giver adgang til konfiguration i web.xml for
den enkelte JSP-side eller servlet.</P>
<P CLASS="klasseoversigt-western">String getInitParameter(String
navn)</P>
<P CLASS="klasseoversigt-western">  Giver v&aelig;rdien af
initialiseringsparameteren <I>navn</I> defineret for websiden i
web.xml.</P>
<P CLASS="klasseoversigt-western">Enumeration getInitParameterNames()</P>
<P CLASS="klasseoversigt-western">  Giver en opremsning af navnene p&aring;
alle initialiseringsparametrene for websiden.</P>

<P CLASS="western">Eksempel</P>
<PRE CLASS="kode-western">&lt;web-app&gt;
  .. 
  &lt;servlet&gt;
    &lt;servlet-name&gt;<SPAN LANG="da-DK">jspside</SPAN>&lt;/servlet-name&gt;
    &lt;jsp-file&gt;<SPAN STYLE="font-weight: medium">/<SPAN LANG="da-DK">jspside.jsp</SPAN></SPAN>&lt;/jsp-file&gt;
<B>    &lt;<SPAN LANG="da-DK">init</SPAN>-param&gt;</B>
<B>      &lt;param-name&gt;tekst&lt;/param-name&gt;</B>
<B>      &lt;param-value&gt;Dette er en tekst fra web.xml&lt;/param-value&gt;</B>
<B>    &lt;/init-param&gt;</B>
<B> </B> &lt;/servlet&gt;

&lt;/web-app&gt;</PRE>
<P CLASS="western">Fra en JSP-side ville det kunne dette hentes med</P>
<PRE CLASS="kode-western">    <SPAN LANG="da-DK">config.getInitParameter</SPAN>(&quot;tekst&quot;)</PRE><P CLASS="western">
som ville returnere strengen &quot;Dette er en tekst fra web.xml&quot;.</P>
<P CLASS="western">Fra en servlet <SPAN STYLE="font-weight: medium">kunne
teksten hentes med</SPAN></P>
<PRE CLASS="kode-western">    getInitParameter(&quot;tekst&quot;));</PRE>

<H3 CLASS="western">4.5.7 <a name='afsn4.5.7'></a>page - selve JSP-siden</H3>
<P CLASS="western">Dette objekt repr&aelig;senterer selve JSP-siden.
Det er her  taget med for en ordens skyld, selvom der ikke er meget
man kan bruge det til i praksis.</P>

<H3 CLASS="western">4.5.8 <a name='afsn4.5.8'></a>exception - undtagelse opst&aring;et under
k&oslash;rsel</H3>
<P CLASS="western">Objektet exception (af type <SPAN LANG="da-DK">Exception</SPAN>)
repr&aelig;senterer en undtagelse der opstod under k&oslash;rsel af
en JSP-side. Objektet er kun defineret p&aring; fejlmeddelelsessider
(hvor side-direktivet isErrorPage er sat til &quot;true&quot;). 
</P>
<P CLASS="western">Se ogs&aring; <a href='kapitel10.jsp#afsn10.4.5'>afsnit 10.4.5</a>. Et eksempel findes i
<a href='kapitel4.jsp#afsn4.4'>afsnit 4.4</a>.</P>

<H3 CLASS="western">4.5.9 <a name='afsn4.5.9'></a>pageContext - alle objekterne samlet i &eacute;t</H3>
<P CLASS="western">Objektet pageContext (af type <SPAN LANG="da-DK">PageContext</SPAN>
i pakken javax.servlet.jsp) giver adgang til alle de andre implicit
definerede objekter. Det kan v&aelig;re nyttigt at bruge, hvis man
&oslash;nsker at have alle de implicitte objekter samlet i &eacute;t
objekt - f.eks. til et metodekald.</P>
<P CLASS="klasseoversigt-western">JspWriter <SPAN LANG="da-DK">getOut</SPAN>()<BR>Giver
out-objektet</P>
<P CLASS="klasseoversigt-western">HttpSession <SPAN LANG="da-DK">getSession</SPAN>()<BR>Giver
session-objektet</P>
<P CLASS="klasseoversigt-western">Object <SPAN LANG="da-DK">getPage</SPAN>()<BR>Giver
page-objektet</P>
<P CLASS="klasseoversigt-western"><SPAN LANG="da-DK">ServletRequest</SPAN>
<SPAN LANG="da-DK">getRequest</SPAN>()<BR>Giver request-objektet</P>
<P CLASS="klasseoversigt-western"><SPAN LANG="da-DK">ServletResponse</SPAN>
<SPAN LANG="da-DK">getResponse</SPAN>()<BR>Giver response-objektet</P>
<P CLASS="klasseoversigt-western">Exception <SPAN LANG="da-DK">getException</SPAN>()<BR>Giver
exception-objektet</P>
<P CLASS="klasseoversigt-western">ServletConfig
<SPAN LANG="da-DK">getServletConfig</SPAN>()<BR>Giver config-objektet</P>
<P CLASS="klasseoversigt-western">ServletContext
getServletContext()<BR>Giver application-objektet</P>

<H2 CLASS="western" STYLE="">4.6 <a name='afsn4.6'></a>Opgaver</SPAN></H2>
<H4 CLASS="western">Forbedring af &oslash;nskeseddel</H4>
<OL>
  <LI><P CLASS="western">Forbedr &oslash;nskeseddel-eksemplet i afsnit
  4.1.1, s&aring;dan at brugeren ogs&aring; kan angive sit navn.
  Navnet huskes efterf&oslash;lgende i session-objektet og skrives i
  sidens titel.</P>
  <LI><P CLASS="western">Lav mulighed for, at brugeren kan slette alle
  sine &oslash;nsker (navnet forbliver)</P>
  <LI><P CLASS="western">Lav mulighed for, at brugeren kan 'logge ud'
  (alle &oslash;nsker og navnet slettet).<BR>Pr&oslash;v at bruge
  session.invalidate() (beskrevet i <a href='kapitel4.jsp#afsn4.5.4'>afsnit 4.5.4</a>) for at smide
  sessionen v&aelig;k.</P>
</OL>

<H4 CLASS="western">Opgave: Afgiv din stemme</H4>
<P CLASS="western">Lav et program, hvor man kan angive, hvem man vil
stemme p&aring; til n&aelig;ste valg. Lad f.eks. brugeren v&aelig;lge
mellem 4 partier: Venstre, Konservative, Socialdemokratiet og SF. 
</P>
<P CLASS="western">Benyt radioknapper, s&aring;dan at man kun kan
stemme p&aring; et parti ad gangen.<BR>Opt&aelig;l stemmerne og vis
resultatet p&aring; sk&aelig;rmen hver gang brugeren har stemt.
<BR>Vink: Brug session- og application-objektet. Du kan s&oslash;ge
inspiration ved at kigge i <a href='kapitel3.jsp#afsn3.3'>afsnit 3.3</a>, Appendiks: Typer af formularfelter.</P>

<H2 CLASS="western">4.7 <a name='afsn4.7'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel4.jsp#afsn4.7">
  <input type='checkbox' name='vis' value='4.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">4.8 <a name='afsn4.8'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel4.jsp#afsn4.8">
  <input type='checkbox' name='vis' value='4.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">4.9 <a name='afsn4.9'></a>Avance<SPAN LANG="da-DK">ret:
Fejlfinding i JSP</SPAN></SPAN></H2>
<P CLASS="western">Det kan til tider v&aelig;re sv&aelig;rt at finde
og rette fejl i JSP-sider. Her f&oslash;lger et par id&eacute;er til,
hvordan du kan lokalisere og rette fejlene. 
</P>
<H3 CLASS="western">4.9.1 <a name='afsn4.9.1'></a>Del og hersk</H3>
<P CLASS="western">Har du en fejl, der driller, er det altid en god
strategi, at pr&oslash;ve at isolere fejlen. 
</P>
<P CLASS="western">Ofte st&aring;r man med en udgave af koden, der
virker og en, der ikke virker. Pr&oslash;v da 'del og hersk'-metoden:
Find frem til fejlen ved langsomt at kopiere koden over (eller
kommentere den ud og derp&aring; kommentere den ind igen, bid for
bid), s&aring;dan at du tiln&aelig;rmer den kode, der virker, til
den, der ikke virker.</P>
<H3 CLASS="western">4.9.2 <a name='afsn4.9.2'></a>Tjek om blokparenteser er balancerede</H3>
<P CLASS="western">Som n&aelig;vnt i <a href='kapitel2.jsp#afsn2.3.1'>afsnit 2.3.1</a>, Blandet Java og HTML,
skal man v&aelig;re meget omhyggelig med at omkranse HTML-kode i {-
og }-parenteser og s&oslash;rge for, at der altid er lige mange
{-startparenteser som }-slutparenteser.</P>
<P CLASS="western">Er der rod med parenteserne f&aring;r man typisk
fejlmeddelelserne:</P>
<PRE CLASS="western">  'try' without 'catch' or 'finally'
  'catch' without 'try'
  'else' without 'if'</PRE>
<H3 CLASS="western">4.9.3 <a name='afsn4.9.3'></a>Kigge p&aring; den oversatte servlet</H3>
<P CLASS="western">JSP-siden bliver internt oversat til en servlet,
der s&aring; overs&aelig;ttes igen, fra .java-kildetekst til en bin&aelig;r
.class-fil (beskrevet i <a href='kapitel7.jsp#afsn7.3'>afsnit 7.3</a>, Avanceret: JSP-siders interne virkem&aring;de).
</P>
<P CLASS="western">Det er ofte sv&aelig;rt at finde fejl i en
JSP-side, fordi de linjenumre, der angives i fejlmeddelelsen, normalt
henviser til linjenumre i servlettens .java-kildetekst i stedet for
de oprindelige linjenumre i JSP-siden.</P>
<P CLASS="western">Udviklingsmilj&oslash;er som (den kommercielle
udgave af) Borland JBuilder, Sun One Studio o.s.v. tager h&oslash;jde
for dette og finder de oprindelige linjenumre og tjekker ogs&aring;
l&oslash;bende JSP-sidernes syntaks, s&aring; man med det samme ser
fejlen det rigtige sted.</P>
<P CLASS="western">De oversatte servletter ligger normalt i
work/-mappen i webserveren og hedder nogenlunde det samme som
JSP-siderne (beskrevet i <a href='kapitel7.jsp#afsn7.3'>afsnit 7.3</a>).</P>
<H3 CLASS="western">4.9.4 <a name='afsn4.9.4'></a>Kigge i log-filerne</H3>
<P CLASS="western">N&aring;r der opst&aring;r en fejl skrives en
fejlmeddelelse i webserverens log. Det kan derfor v&aelig;re en god
id&eacute; at kigge i disse. 
</P>
<P CLASS="western">Under Tomcat findes logfilerne i mappen logs/. 
</P>
<P CLASS="western">En snild m&aring;de under Linux til at kigge i
alle logfilerne p&aring; &eacute;n gang er fra kommandolinjen at
skrive:</P>
<PRE CLASS="kode-western">tail -f -n0 logs/*</PRE><P CLASS="western">
Kommandoen 'tail' &aring;bner herefter alle logfilerne og f&oslash;lger
med i dem (-f), s&aring;dan at alle nye fejlmeddelelser skrives ud p&aring;
sk&aelig;rmen.</P>
<H4 CLASS="western">Husk altid at udskrive fejlmeddelelserne og
staksporene</H4>
<P CLASS="western">Det er selvf&oslash;lgelig afg&oslash;rende for,
om der er noget interessant at se i logfilerne, at dit program ikke
undertrykker eventuelle fejl, men i stedet skriver dem ud.</P>
<P CLASS="western">Det er alts&aring; meget v&aelig;sentligt at der
ingen steder st&aring;r:</P>
<PRE CLASS="kode-western">      try {
<SPAN LANG="da-DK">        ...</SPAN>
<SPAN LANG="da-DK">      } catch (Exception e) { } <I>// Forkert! Fejlen undertrykkes!</I></SPAN></PRE><P CLASS="western">
men i stedet, i alle try-catch-blokke, st&aring;r:</P>
<PRE CLASS="kode-western">      try {
<SPAN LANG="da-DK">        ...</SPAN>
<SPAN LANG="da-DK">      } catch (Exception e) { <B>e.printStackTrace();</B> } <I>// Udskriv stakspor i loggen</I></SPAN></PRE><P CLASS="western">
s&aring;dan at staksporet udskrives i loggen</P>
<H3 CLASS="western">4.9.5 <a name='afsn4.9.5'></a>Forst&aring; staksporet</H3>
<P CLASS="western">Et eksempel p&aring; et stakspor er vist nedenfor.
Staksporet fort&aelig;ller pr&aelig;cist hvad der skete, men det er
kun meget f&aring; dele af det (herunder fremh&aelig;vet med fed),
der har vores interesse. De andre afspejler nemlig blot m&aring;den
webserveren og klassebibliotekerne fungerer p&aring;:</P>
<PRE CLASS="western"><B>java.sql.SQLException: General error,  message from server: &quot;Table 'test.gaestebog' doesn't exist&quot;</B>
<SPAN LANG="da-DK">  com.mysql.jdbc.MysqlIO.checkErrorPacket(MysqlIO.java:1825)</SPAN>
<SPAN LANG="da-DK">  com.mysql.jdbc.MysqlIO.sendCommand(MysqlIO.java:1020)</SPAN>
<SPAN LANG="da-DK">  com.mysql.jdbc.MysqlIO.sqlQueryDirect(MysqlIO.java:1109)</SPAN>
<SPAN LANG="da-DK">  com.mysql.jdbc.MysqlIO.sqlQuery(MysqlIO.java:1070)</SPAN>
<SPAN LANG="da-DK">  com.mysql.jdbc.Connection.execSQL(Connection.java:2027)</SPAN>
<SPAN LANG="da-DK">  com.mysql.jdbc.Connection.execSQL(Connection.java:1984)</SPAN>
<SPAN LANG="da-DK">  com.mysql.jdbc.Statement.executeQuery(Statement.java:1152)</SPAN>
<SPAN LANG="da-DK"><B>  org.apache.jsp.JSP.kode.kapitel_05.gaestebog_jsp._jspService(gaestebog_jsp.java:58)</B></SPAN>
<SPAN LANG="da-DK">  org.apache.jasper.runtime.HttpJspBase.service(HttpJspBase.java:133)</SPAN>
<SPAN LANG="da-DK">  javax.servlet.http.HttpServlet.service(HttpServlet.java:856)</SPAN>
<SPAN LANG="da-DK">  org.apache.jasper.servlet.JspServletWrapper.service(JspServletWrapper.java:311)</SPAN>
<SPAN LANG="da-DK">  org.apache.jasper.servlet.JspServlet.serviceJspFile(JspServlet.java:301)</SPAN>
<SPAN LANG="da-DK">  org.apache.jasper.servlet.JspServlet.service(JspServlet.java:248)</SPAN>
<SPAN LANG="da-DK">  javax.servlet.http.HttpServlet.service(HttpServlet.java:856)</SPAN></PRE><P CLASS="western">
Oversat til dansk siger fejlmeddelelsen at:</P>
<UL>
  <LI><P CLASS="western">Fejlen opstod i metoden checkErrorPacket(),
  p&aring; linje 1825 i filen MysqlIO.java.</P>
  <LI><P CLASS="western">Denne metode blev kaldt fra sendCommand(), p&aring;
  linje 1020 i filen MysqlIO.java.</P>
  <LI><P CLASS="western">... (flere metoder der var i gang med at
  kalde hinanden) ...</P>
  <LI><P CLASS="western"><B>executeQuery() blev kaldt i metoden
  _jspService() p&aring; linje 58 i gaestebog_jsp.java</B></P>
  <LI><P CLASS="western">... (flere metoder der var i gang med at
  blive kaldt) ...</P>
</UL>

<P CLASS="western">Som regel fort&aelig;ller staksporet alene nok til
at man kan finde fejlen. Kigger man p&aring; gaestebog.jsp (den
kommer i <a href='kapitel5.jsp#afsn5.5'>afsnit 5.5</a>, Eksempel - g&aelig;stebog) ser man at
executeQuery() kun kaldes &eacute;t sted, og man har s&aring;ledes
fundet frem til stedet, hvor fejlen opstod.</P>
<P CLASS="western"><SPAN LANG="da-DK">Et man stadig i tvivl om,
pr&aelig;cis hvor fejlen opstod (m&aring;ske e</SPAN>r der flere
steder med kald til executeQuery()), m&aring; man bruge sin viden om,
at det skete i linje 58 i gaestebog_jsp.java og kigge p&aring; den
oversatte servlet (ligger normalt i work/-mappen i w<SPAN LANG="da-DK">ebserveren,
se <a href='kapitel7.jsp#afsn7.3.1'>afsnit 7.3.1</a>, Kigge i de genererede servletter).</SPAN></P>
<H3 CLASS="western">4.9.6 <a name='afsn4.9.6'></a>Hvis klasse(bibliotek)er ikke kan findes</H3>
<P CLASS="western"><SPAN LANG="da-DK">F&aring;r du fejlen
NoClassDefFoundError, er det et symptom p&aring;, at en klasse ikke
kan findes. Det kan f.eks. ske, n&aring;r du pr&oslash;ver at indl&aelig;se
en databasedriver (der kan du ogs&aring; f&aring; 'No suitable
driver') eller, hvis du bruger ekstra klassebiblioteker ud over de,
der er defineret i standard Java JDK.</SPAN></P>
<P CLASS="western">Ekstra klassebiblioteker og drivere f&aring;s
n&aelig;sten altid som JAR-filer (der er et ZIP-arkiv med en r&aelig;kke
.class-filer).</P>
<P CLASS="western">Der er mange muligheder for at l&oslash;se
problemet med, at en klasse ikke kan findes:</P>
<UL>
  <LI><P CLASS="western">Hvis du arbejder i et udviklingsv&aelig;rkt&oslash;j
  (f.eks. for at kunne overs&aelig;tte nogle klasser/JSP-sider der
  bruger klasserne): Inklud&eacute;r de rigtige biblioteker (eng.:
  libraries) med de JAR-filer, der indeholder klasserne (opret evt. et
  nyt bibliotek), i dit projekt.</P>
  <LI><P CLASS="western">Hvis programmet startes selvst&aelig;ndigt,
  evt. fra kommandolinjen: S&aelig;t en henvisning til JAR-filen ind i
  milj&oslash;variablen CLASSPATH</P>
  <LI><P CLASS="western">Hvis klasserne skal v&aelig;re kendt i ALLE
  Java-programmer (der k&oslash;rer p&aring; en bestemt JDK): Kopier
  JAR-filerne over i JDK-et, under jre/lib/ext/-mappen</P>
  <LI><P CLASS="western">Hvis klasserne skal v&aelig;re kendt i ALLE
  webapplikationer (der k&oslash;rer i en bestemt Tomcat webserver):
  Kopier JAR-filerne over i Tomcats common/lib/-mappe</P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Hvis klasserne skal v&aelig;re
  kendt i en webapplikation, s&aring;dan at denne webapplikation ogs&aring;
  kunne flyttes over p&aring; en anden server: Kopi&eacute;r
  JAR-filerne over i webapplikationens WEB-INF/lib/-mappe (opret evt
  mappen - se ogs&aring; <a href='kapitel7.jsp#afsn7.4'>afsnit 7.4</a>)</SPAN>.</P>
</UL>

<P CLASS="western">I princippet kan alle mulighederne v&aelig;re lige
gode til at l&oslash;se problemet, men n&aring;r du har f&aring;et
det til at virke, s&aring; brug lidt tid p&aring; at overveje om
l&oslash;sningen er den rigtige for dig (det er f.eks. lidt kedeligt
hvis du ofte skifter JDK og du netop har lagt databaseklasserne ind i
dit JDK).</P>


<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Omdirigering
  skal ske s&aring; tidligt p&aring; siden, at man kan v&aelig;re
  sikker p&aring;, at der ikke er genereret s&aring; meget HTML, at
  bufferen er l&oslash;bet fuld og HTTP-hovedet (se <a href='kapitel3.jsp#afsn3.7'>afsnit 3.7</a>) og den
  f&oslash;rste del af data s&aring;ledes er sendt til klienten. N&aring;r
  f&oslash;rst data er sendt til klienten, kan webserveren ikke
  'fortryde' og i stedet omdirigere til en anden side.<BR>For
  <SPAN LANG="da-DK">servletter</SPAN> er der ingen output-buffer, s&aring;
  i servletter skal omdirigering ske inden der har v&aelig;ret noget
  output overhovedet.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Som
  vi senere skal se, i <a href='kapitel7.jsp#afsn7.3'>afsnit 7.3</a>, Avanceret: JSP-siders interne virkem&aring;de,
  bliver JSP-sider lavet om til en metode i en klasse. Man kan undg&aring;
  at den efterf&oslash;lgende kode i metoden udf&oslash;res ved at
  returnere fra metoden, med 'return;'. I <a href='kapitel10.jsp#afsn10.4.4'>afsnit 10.4.4</a> er der et
  eksempel p&aring; dette.</P>
</DIV>
<DIV ID="sdfootnote3">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote3sym" HREF="#sdfootnote3anc">3</A>Denne
  opf&oslash;rsel kan sl&aring;s fra ved at s&aelig;tte
  session=&quot;false&quot; i sidedirektivet med <BR>&lt;%@ page
  session=&quot;false&quot; %&gt;</P>
</DIV>
<DIV ID="sdfootnote4">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote4sym" HREF="#sdfootnote4anc">4</A>En
  mindre hensigstm&aelig;ssig m&aring;de kunne v&aelig;re at bruge en
  klassevariabel i en separat klasse.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
